<?php


class CompetitorModelo
{
    const ORO = 1;
    const PLATA = 2;
    const BRONCE = 3;
    const CUARTO = 4;
    const QUINTO = 5;
    const SEXTO = 6;
    const SEPTIMO = 7;
    const OCTAVO = 8;
    private $dni;
    private $nombre;
    private $apellido1;
    private $apellido2;
    private $paisISOA3;
    private $autonomia;
    private $provincia;


    private $puntuacion;
    private $email;
    private $CI;

    /**
     * Competitor constructor.
     * @param $dni
     * @param $nombre
     * @param $apellido1
     * @param $apellido2
     * @param $paisISOA3
     * @param $autonomia
     * @param $provincia
     * @param $idCategoriaArbitral
     * @param $email
     */
    public function __construct($dni, $nombre, $apellido1, $apellido2, $paisISOA3, $autonomia, $provincia, $email)
    {
        $this->dni = $dni;
        $this->nombre = $nombre;
        $this->apellido1 = $apellido1;
        $this->apellido2 = $apellido2;
        $this->paisISOA3 = $paisISOA3;
        $this->autonomia = $autonomia;
        $this->provincia = $provincia;
        $this->email = $email;
        $this->CI = get_instance();
        $this->CI->load->model('competitorModel');
        $this->puntuacion = array('oro' => 0, 'plata' => 0, 'bronce' => 0,'quinto' => 0, 'septimo' =>0);
    }

    /**
     * Añadir una puntuacion
     * @param $puntuacion
     */
    public function addPuntuacion($puntuacion)
    {
        switch ($puntuacion) {
            case self::ORO :
                $this->puntuacion['oro'] = $this->puntuacion['oro'] + 1;

                break;
            case self::PLATA:
                $this->puntuacion['plata'] = $this->puntuacion['plata'] + 1;
                break;
            case self::BRONCE:
                $this->puntuacion['bronce'] = $this->puntuacion['bronce'] + 1;
                break;
            case self::CUARTO:
                $this->puntuacion['bronce'] = $this->puntuacion['bronce'] + 1;
                break;
            case self::QUINTO:
                $this->puntuacion['quinto'] = $this->puntuacion['quinto'] + 1;
                break;
            case self::SEXTO:
                $this->puntuacion['quinto'] = $this->puntuacion['quinto'] + 1;
                break;
            case self::SEPTIMO:
                $this->puntuacion['septimo'] = $this->puntuacion['septimo'] + 1;
                break;
            case self::OCTAVO:
                $this->puntuacion['septimo'] = $this->puntuacion['septimo'] + 1;
                break;

            default:

        }
    }

    /**
     * @return Puntuacion
     */
    public function getPuntuacion()
    {
        return $this->puntuacion;
    }

    /**
     * Funcion que devuelve si existe o no un competidor
     * @param $dni Identificador del competidor
     * @return bool true en caso afirmativo es decir que exista, false en caso contrario
     */
    public static function existsCompetitor($dni)
    {

        $CI = get_instance();
        $CI->load->model('competitorModel');
        return $CI->competitorModel->getCompetitorByDni($dni) != null;


    }

    /**
     * @deprecated
     * Obtner un competidor en funcion de los parametros dados
     * @param $name Nombre del competidor
     * @param $surname
     * @return mixed
     */
    public static function getCompetitor($name, $surname)
    {
        $CI = get_instance();
        $CI->load->model('competitorModel');
        return $CI->competitorModel->getCompetitor($name, $surname);
    }

    /**
     * Obtener un competidor por dni
     * @param $dni Identificador unico de un competidor
     * @return Competidor
     */
    public static function getCompetitorByDni($dni)
    {
        $CI = get_instance();
        $CI->load->model('competitorModel');
        return $CI->competitorModel->getCompetitorByDni($dni);
    }

    /**
     * Funcion para crear un competidor
     * @param $competitor datos de un competidor
     * @return mixed
     */
    public static function createCompetitor($competitor)
    {
        $CI = get_instance();
        $CI->load->model('competitorModel');
        return $CI->competitorModel->createCompetitor($competitor);
    }

    /**
     * Crear una inscripcion
     * @param $idCompetition
     * @param $dni
     * @param $teamName
     * @return mixed
     */
    public static function createInscription($idCompetition, $dni, $teamName)
    {
        $CI = get_instance();
        $CI->load->model('competitorModel');
        $current_date = date('Y-m-d');

        return $CI->competitorModel->createInscription($dni, $idCompetition, $teamName, $current_date);
    }

    /**
     * Crear una participacion
     * @param $idWeight
     * @param $dni
     * @param $competition_date
     * @return mixed
     */
    public static function createParticipation($idWeight, $dni, $competition_date)
    {
        $CI = get_instance();
        $CI->load->model('competitorModel');
        return $CI->competitorModel->createParticipation($dni, $idWeight, $competition_date);
    }

    /**
     * @param $idCompetition
     * @return bool si existe una inscripcion con el DNI y idCompeticion pasados por parametro
     */
    public function existsInscription($idCompetition)
    {
        return $this->CI->competitorModel->getInscription($this->dni, $idCompetition) != null;
    }

    /**
     * Obtener oompetidores por id peso
     * @param $idWeight Ide peso
     * @param $competition_date fecha de la competicion
     * @param $idCompetition Identificador de la competicion
     * @return mixed
     */
    public static function getCompetitorsByIdWeight($idWeight, $competition_date, $idCompetition)
    {
        $CI = get_instance();
        $CI->load->model('competitorModel');
        return $CI->competitorModel->getCompetitorsByIdWeight($idWeight, $competition_date, $idCompetition);
    }

    /**
     * Funcion que devuelve los dnis
     * @return dnis[]
     */
    public static function getallDnis()
    {
        $CI = get_instance();
        $CI->load->model('competitorModel');
        return $CI->competitorModel->getAllDnis();
    }

    /**
     * Funcion que devuelve los arbitros y competidores
     * @return Persona []
     */
    public static function getPeople()
    {
        $CI = get_instance();
        $CI->load->model('competitorModel');
        return $CI->competitorModel->getPeople();
    }

    /**
     * @return mixed
     */
    public function getDni()
    {
        return $this->dni;
    }

    /**
     * @param mixed $dni
     */
    public function setDni($dni)
    {
        $this->dni = $dni;
    }

    /**
     * @return mixed
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * @param mixed $nombre
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    }

    /**
     * @return mixed
     */
    public function getApellido1()
    {
        return $this->apellido1;
    }

    /**
     * @param mixed $apellido1
     */
    public function setApellido1($apellido1)
    {
        $this->apellido1 = $apellido1;
    }

    /**
     * @return mixed
     */
    public function getApellido2()
    {
        return $this->apellido2;
    }

    /**
     * @param mixed $apellido2
     */
    public function setApellido2($apellido2)
    {
        $this->apellido2 = $apellido2;
    }

    /**
     * @return mixed
     */
    public function getPaisISOA3()
    {
        return $this->paisISOA3;
    }

    /**
     * @param mixed $paisISOA3
     */
    public function setPaisISOA3($paisISOA3)
    {
        $this->paisISOA3 = $paisISOA3;
    }

    /**
     * @return mixed
     */
    public function getAutonomia()
    {
        return $this->autonomia;
    }

    /**
     * @param mixed $autonomia
     */
    public function setAutonomia($autonomia)
    {
        $this->autonomia = $autonomia;
    }

    /**
     * @return mixed
     */
    public function getProvincia()
    {
        return $this->provincia;
    }

    /**
     * @param mixed $provincia
     */
    public function setProvincia($provincia)
    {
        $this->provincia = $provincia;
    }

    /**
     * @return mixed
     */
    public function getIdCategoriaArbitral()
    {
        return $this->idCategoriaArbitral;
    }

    /**
     * @param mixed $idCategoriaArbitral
     */
    public function setIdCategoriaArbitral($idCategoriaArbitral)
    {
        $this->idCategoriaArbitral = $idCategoriaArbitral;
    }

    /**
     * @return mixed
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param mixed $email
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }


}
